/*
 * Decompiled with CFR 0.152.
 */
package com.ineffabletech.bitbucket.squash.check;

import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.stereotype.Component;

@Component(value="canSquashMergeCheck")
public class SquashMergeCheck
implements RepositoryMergeCheck {
    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        Optional strategyId = request.getStrategyId();
        if (!strategyId.isPresent()) {
            return RepositoryHookResult.accepted();
        }
        if (!((String)strategyId.get()).contains("squash")) {
            return RepositoryHookResult.accepted();
        }
        CharSequence[] branches = context.getSettings().getString("branches", "main,master").split(",");
        String branch = request.getToRef().getDisplayId();
        if (Arrays.stream(branches).noneMatch(br -> br.equals(branch))) {
            return RepositoryHookResult.accepted();
        }
        return RepositoryHookResult.rejected((String)"Squash denied", (String)("Not allowed to squash to branch(es): " + String.join((CharSequence)", ", branches)));
    }
}

